<?php
header('Content-Type: application/json; charset=utf-8');

$dir = __DIR__;             // Där m4v.php ligger
$files = glob($dir . '/*.m4v');

// Bygg webbsökväg relativt document_root
$baseUrl = str_replace($_SERVER['DOCUMENT_ROOT'], '', $dir);

$playlist = [];

foreach ($files as $file) {
    $filename = basename($file);

    // Gör titel av filnamnet
    $title = preg_replace('/\.[^.]+$/', '', $filename);  // ta bort ändelse
    $title = str_replace(['.', '_'], ' ', $title);       // byt ut . och _ mot mellanslag
    $title = preg_replace('/^\d+\s*/', '', $title);      // ta bort inledande siffror
    $title = ucfirst(trim($title));                      // stor bokstav på första

    $playlist[] = [
        'title' => $title,
        'file'  => $baseUrl . '/' . $filename            // absolut sökväg från roten
    ];
}

echo json_encode($playlist, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

