<?php
header('Content-Type: application/json; charset=utf-8');

// Roten där dina album ligger
$baseDir = __DIR__;
$baseUrl = '/media/bilder/anekdot';

$rii = new RecursiveIteratorIterator(
    new RecursiveDirectoryIterator($baseDir, RecursiveDirectoryIterator::SKIP_DOTS)
);

$files = [];
foreach ($rii as $file) {
    if ($file->isDir()) continue;

    $ext = strtolower(pathinfo($file->getFilename(), PATHINFO_EXTENSION));
    if (in_array($ext, ['jpg','jpeg','png','gif','webp'])) {
        $relativePath = str_replace($baseDir, '', $file->getPathname());
        $relativePath = ltrim(str_replace('\\','/',$relativePath), '/');

        $files[] = [
            'url'   => $baseUrl . '/' . $relativePath,
            'album' => dirname($relativePath)   // ger mappnamn/album
        ];
    }
}

echo json_encode($files, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

